HorseHelper = {};

HorseHelper.metadata = {
	interface = "FS25 ...", --new LS25
	title = "HorseHelper",
	notes = "Keine Lust mehr auf das ausreiten/striegeln der Pferde? Dieser Helfer nimmt dir diese Aufgabe ab und reitet/striegelt deine Pferde um ~06:00/~12:00/~18:00 Uhr und ~24:00 Uhr. (Optional 1x pro Tag)",
	author = "(by HappyLooser)",
	version = "1.0.0.0",
	build = 1,
	datum = "20.03.2025",
	update = "26.03.2025",
	discord = "HappyLooser Modding https://discord.gg/FwktJh4FZ2",
	info = "Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

HorseHelper.priceMultiple = 2.5; --2.5/days per periode (more days per periode = cheaper)
HorseHelper.ridingHours = {0,6,12,18,24}; --optional edit here, differenz min 1 also {0,2,4 .....}
HorseHelper.ridingDay = false; --optional 1x pro Day (set true) --better for perfomance ! MP ?

function HorseHelper:loadMap(mapName)
	print("---loading ".. tostring(HorseHelper.metadata.title).. " ".. tostring(HorseHelper.metadata.version).. "(#".. tostring(HorseHelper.metadata.build).. ") ".. tostring(HorseHelper.metadata.author).. "---")	
	HorseHelper.canRidding = true;	
	if not HorseHelper:isMP() or HorseHelper:getDetiServer() or HorseHelper:getHostServer() then
		horsehelper = {};
		function horsehelper:onHourDayChanged()
			if HorseHelper.canRidding and HorseHelper:isRiddingHours() then
				local price = 0;
				for _, object in pairs(g_currentMission.husbandrySystem.placeables) do
					if object ~= nil and object.typeName:lower() == "horsehusbandry" or string.find(object.typeName:lower(), "horse") then
						price = 0;
						for _, horse in pairs(object:getClusterSystem().clusters) do
							if horse ~= nil then
								if horse.riding ~= nil and horse.riding < 100 then
									local changeRiding = 100-horse.riding;
									price = price + (changeRiding*HorseHelper.priceMultiple);
									horse:changeRiding(changeRiding);
								end;
								if horse.fitness ~= nil and horse.fitness < 100 then
									local changeFitness = 100-horse.fitness;
									price = price + (changeFitness*HorseHelper.priceMultiple);
									horse:changeFitness(changeFitness);
								end;
								if horse.dirt ~= nil and horse.dirt > 0 then
									local changeDirt = horse.dirt;
									price = price + (changeDirt*HorseHelper.priceMultiple);
									horse:changeDirt(-changeDirt);
								end;
							end;
						end;
						if price > 0 and (not HorseHelper:isMP() or HorseHelper:getDetiServer() or HorseHelper:getHostServer()) then
							price = price/g_currentMission.environment.daysPerPeriod 
							g_currentMission:addMoney(-price, object.ownerFarmId, MoneyType.AI, true, true);							
						end;						
					end;
				end;					
				HorseHelper.canRidding = false;				
			end;	
			if not HorseHelper.canRidding and not HorseHelper:isRiddingHours() then
				HorseHelper.canRidding = true;
			end;		
		end;
		if not HorseHelper.ridingDay then
			FSBaseMission.onHourChanged = Utils.prependedFunction(FSBaseMission.onHourChanged, horsehelper.onHourDayChanged);
		else
			FSBaseMission.onDayChanged = Utils.appendedFunction(FSBaseMission.onDayChanged, horsehelper.onHourDayChanged);
		end;
	else	
		print("---".. tostring(HorseHelper.metadata.title).. " not loaded for MP Client---");
	end;
end;
addModEventListener(HorseHelper);

function HorseHelper:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function HorseHelper:getHostServer()		
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil and g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function HorseHelper:isMP()		
	return g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function HorseHelper:isRiddingHours()
	if HorseHelper.ridingDay then return true;end;
	for h=1, #HorseHelper.ridingHours do
		if HorseHelper.ridingHours[h] == g_currentMission.environment.currentHour then return true;end;
	end;
	return false;
end;