--
-- MobileWorkshopUtil
--
-- @author Rockstar
-- @date 30/11/2024
--


MobileWorkshopUtil = {}

function MobileWorkshopUtil.prependedFunction(oldTarget, oldFunc, newTarget, newFunc)
	local superFunc = oldTarget[oldFunc]

	oldTarget[oldFunc] = function(...)
		newTarget[newFunc](newTarget, ...)
		superFunc(...)
	end
end

function MobileWorkshopUtil.appendedFunction(oldTarget, oldFunc, newTarget, newFunc)
	local superFunc = oldTarget[oldFunc]

	oldTarget[oldFunc] = function(...)
		superFunc(...)
		newTarget[newFunc](newTarget, ...)
	end
end

function MobileWorkshopUtil.overwrittenFunction(oldTarget, oldFunc, newTarget, newFunc, isStatic)
	local superFunc = oldTarget[oldFunc]

	if isStatic then
		oldTarget[oldFunc] = function(...)
			return newTarget[newFunc](newTarget, superFunc, ...)
		end
	else
		oldTarget[oldFunc] = function(self, ...)
			return newTarget[newFunc](newTarget, self, superFunc, ...)
		end
	end
end